import pycsmm
import os
import shutil
import json

UI_MSGS_ALL = {}

UI_MSGS = {
	"de": {
		0000: "Lines of text goes here",
		0001: "Another line of text goes here",
	},
	"en": {
		0000: "Lines of text goes here",
		0001: "Another line of text goes here",
	},
	"fr": {
		0000: "Lines of text goes here",
		0001: "Another line of text goes here",
	},
	"it": {
		0000: "Lines of text goes here",
		0001: "Another line of text goes here",
	},
	"jp": {
		0000: "Lines of text goes here",
		0001: "Another line of text goes here",
	},
	"su": {
		0000: "Lines of text goes here",
		0001: "Another line of text goes here",
	},
	"uk": {
		0000: "Lines of text goes here",
		0001: "Another line of text goes here",
	}
}

MODID = __name__

def replUiMessages(msgDict, toReplaceWith):
	for k,v in toReplaceWith.items():
		msgDict[k] = v

def replCharacterIcons(locale, arcDir, modpackDir):
	gameCharacterIconAll = os.path.join(modpackDir, 'game/ui_game_f_<character_code>.arc')   # MODIFY THIS
	for dirEntry in os.scandir(gameCharacterIconAll):
		tplPath = os.path.join(arcDir, 'arc/timg', os.path.splitext(dirEntry.name)[0] + '.tpl')
		pycsmm.convertPngToTpl(dirEntry.path, tplPath)

def replCharacterDartIcons(locale, brresDir, modpackDir):
	gameCharacterIconDarts = os.path.join(modpackDir, 'game/mg_darts.brres')
	for dirEntry in os.scandir(gameCharacterIconDarts):
		texPath = os.path.join(brresDir, 'Textures(NW4R)', os.path.splitext(dirEntry.name)[0])
		pycsmm.convertPngToTex(dirEntry.path, texPath)

class Mod(pycsmm.CSMMMod, pycsmm.GeneralInterface, pycsmm.ArcFileInterface, pycsmm.BrresFileInterface, pycsmm.UiMessageInterface):
	def __init__(self):
		pycsmm.CSMMMod.__init__(self)
		pycsmm.GeneralInterface.__init__(self)
		pycsmm.ArcFileInterface.__init__(self)
		pycsmm.BrresFileInterface.__init__(self)
		pycsmm.UiMessageInterface.__init__(self)
	def modId(self):
		return MODID
	def saveFiles(self, root, gameInstance, modList):
		mapper = gameInstance.addressMapper()
		with open(os.path.join(root, 'sys/main.dol'), 'rb+') as mainDol:
			# modify character primary color
			mainDol.seek(mapper.boomToFileAddress(0x80000000))   # MODIFY THIS
			mainDol.write(b'\x00\x00\x00\x00')    # MODIFY THIS

		# modify character model
		modpack_dir = self.modpackDir()
		with open(os.path.join(modpack_dir, f'{MODID}.json'), 'rb') as config_file:
			config = json.load(config_file)
			for command in config:
				copy_from = os.path.join(modpack_dir, command["from"])
				copy_to = os.path.join(root, command["to"])
				if os.path.isdir(copy_from):
					shutil.copytree(copy_from, copy_to, dirs_exist_ok=True)
				else:
					shutil.copy(copy_from, copy_to)


	def saveUiMessages(self):
		return {f'files/localize/ui_message.{k}.csv':
			(lambda root, gameInstance, modList, msgDict, toReplaceWith=v: replUiMessages(msgDict, UI_MSGS_ALL | toReplaceWith))
			for k,v in UI_MSGS.items()}

	def modifyArcFile(self):
		localeToTitleArcFile = {
			'ja': 'files/game/ui_game_f_<character_code>.arc'   # MODIFY THIS
		}
		return {
			arcFile:
			lambda root, gameInstance, modList, arcDir, locale=locale, modpackDir=self.modpackDir(): replCharacterIcons(locale, arcDir, modpackDir)
			for locale, arcFile in localeToTitleArcFile.items()
		}

	def modifyBrresFile(self):
		localeToTitleBrresFile = {
			'ja': 'files/game/mg_darts.brres',
			'en': 'files/game/langEN/mg_darts_EN.brres',
			'de': 'files/game/langDE/mg_darts_DE.brres',
			'su': 'files/game/langES/mg_darts_ES.brres',
			'fr': 'files/game/langFR/mg_darts_FR.brres',
			'it': 'files/game/langIT/mg_darts_IT.brres',
			'uk': 'files/game/langUK/mg_darts_UK.brres',
		}
		return {
			brresFile:
			lambda root, gameInstance, modList, brresDir, locale=locale, modpackDir=self.modpackDir(): replCharacterDartIcons(locale, brresDir, modpackDir)
			for locale, brresFile in localeToTitleBrresFile.items()
		}

mod = Mod()
